<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use \App\main_category;
class MainCategoryController extends Controller
{
    
    public function index()
    {
        $main_category = main_category::all(); // Select
        return view('admin.main_category.list' , compact('main_category')); // while query
    }


    public function create()
    {

        return view('admin.main_category.create');
    }


    public function store()
    {


        $main_category = main_category::create($this->validateData()); // insert
        $this->storeImage($main_category);
        return redirect('/admin/main_category/create')->with("success","Created Successfully"); // send id of inserted

    }

    public function show(main_category $main_category)
    {
        //
    }


    public function edit(main_category $main_category)
    {

        return view('admin.main_category.edit',compact('main_category'));
    }


    public function update(Request $request, main_category $main_category)
    {


        $main_category->update($this->validateData());
        $this->storeImage($main_category);
        return redirect('/admin/main_category/'. $main_category->id . "/edit")->with('success', 'successfully updated');

    }


    public function destroy(main_category $main_category) {


        $main_category->delete();
        return redirect('/admin/main_category');
    }




    private function storeImage($main_category) {


        if(request()->hasFile('img')) {
            $main_category->update([


            'img'=>request()->img->store('uploads','public')



            ]);
        }

    }



    protected function validateData() {


        $mydata =  [
            'title'=>'required' ,
            'details'=>'required',
        ];

        if(request()->hasFile('img')) {
            $mydata['img'] = 'file|image';
        }

        $validatedData = request()->validate($mydata);



        return $validatedData;


    }

}
