<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use \App\news;

class NewsController extends Controller
{

    public function details($id) {

     $news = news::findorfail($id);
    return view('website/news/details',compact('news'));

    }

    
    public function index()
    {
        $news = news::all();
        return view('admin.news.list' , compact('news')); // while query
    }


    public function create()
    {

        return view('admin.news.create');
    }


    public function store()
    {


        $new = news::create($this->validateData()); // insert
        $this->storeImage($new);
        return redirect('/admin/news/create')->with("success","Created Successfully"); // send id of inserted

    }

    public function show($id)
    {
        $new = news::findorfail($id);
        $testmotional = Testmotinals::all();
        $clients = Clients::all();
        return view('website.news.details',compact('new','testmotional','clients'));
    }


    public function edit(news $new)
    {

        return view('admin.news.edit',compact('new'));
    }


    public function update(Request $request, news $new)
    {


        $new->update($this->validateData());
        $this->storeImage($new);
        return redirect('/admin/news/'. $new->id . "/edit")->with('success', 'successfully updated');

    }


    public function destroy(news $new) {


        $new->delete();
        return redirect('/admin/news');
    }




    private function storeImage($new) {


        if(request()->hasFile('header_img')) {
            $new->update([

         //   'header_img' => request()->file('header_img')->store('public/uploads')
                'header_img'=>request()->header_img->store('uploads','public')



            ]);
        }

    }



    protected function validateData() {


        $mydata =  [
            'title'=>'required' ,
            'details'=>'required',
            'video_id'=>'required',
        ];

        if(request()->hasFile('header_img')) {
            $mydata['header_img'] = 'file|image';
        }

        $validatedData = request()->validate($mydata);



        return $validatedData;


    }
}
