<?php

namespace App\Http\Controllers;

use App\Clients;
use App;
use App\service;
use App\sliders;
use \App\Pages;
use App\testmotinals;
use Illuminate\Http\Request;

class PagesController extends Controller
{

    public function details($id) {

     $pages = Pages::findorfail($id);

    return view('website/pages/details',compact('pages'));

    }


    public function homepage($lang) {
        App::setLocale($lang);
        $clients = Clients::all();
        $services  = service::all();
        $sliders = sliders::all();
        return view('website.home.index',compact('clients','services','sliders'));
    }

    public function index()
    {
        $pages = Pages::all();
        return view('admin.pages.list' , compact('pages')); // while query
    }


    public function create()
    {

        return view('admin.pages.create');
    }


    public function store()
    {


        $page = Pages::create($this->validateData()); // insert
        $this->storeImage($page);
        return redirect('/admin/page/create')->with("success","Created Successfully"); // send id of inserted

    }

 

    public function edit(Pages $page)
    {

        return view('admin.pages.edit',compact('page'));
    }


    public function update(Request $request, Pages $page)
    {


        $page->update($this->validateData());
        $this->storeImage($page);
        return redirect('/admin/pages/'. $page->id . "/edit")->with('success', 'successfully updated');

    }


    public function destroy(Pages $page) {


        $page->delete();
        return redirect('/admin/pages');
    }




    private function storeImage($page) {


        if(request()->hasFile('header_img')) {
            $page->update([

         //   'header_img' => request()->file('header_img')->store('public/uploads')
                'header_img'=>request()->header_img->store('uploads','public')



            ]);
        }

    }



    protected function validateData() {


        $mydata =  [
            'title'=>'required' ,
            'details'=>'required',
        ];

        if(request()->hasFile('header_img')) {
            $mydata['header_img'] = 'file|image';
        }

        $validatedData = request()->validate($mydata);



        return $validatedData;


    }

}
