<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use \App\partners;
class PartnersController extends Controller
{
    
    public function index()
    {
        $partners = partners::all(); // Select
        return view('admin.partners.list' , compact('partners')); // while query
    }


    public function create()
    {

        return view('admin.partners.create');
    }


    public function store()
    {


        $partner = partners::create($this->validateData()); // insert
        $this->storeImage($partner);
        return redirect('/admin/partners/create')->with("success","Created Successfully"); // send id of inserted

    }

    public function show(partners $partners)
    {
        //
    }


    public function edit(partners $partner)
    {

        return view('admin.partners.edit',compact('partner'));
    }


    public function update(Request $request, partners $partner)
    {


        $partner->update($this->validateData());
        $this->storeImage($partner);
        return redirect('/admin/partners/'. $partner->id . "/edit")->with('success', 'successfully updated');

    }


    public function destroy(partners $partner) {


        $partner->delete();
        return redirect('/admin/partners');
    }




    private function storeImage($partner) {


        if(request()->hasFile('header_img')) {
            $partner->update([


            'header_img'=>request()->header_img->store('uploads','public')



            ]);
        }

    }



    protected function validateData() {


        $mydata =  [
            'title'=>'required' ,
            'details'=>'required',
        ];

        if(request()->hasFile('header_img')) {
            $mydata['header_img'] = 'file|image';
        }

        $validatedData = request()->validate($mydata);



        return $validatedData;


    }

}
