<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use \App\products;
class ProductsController extends Controller
{
    
    public function index()
    {
        $products = products::all(); // Select
        return view('admin.products.list' , compact('products')); // while query
    }


    public function create()
    {

        return view('admin.products.create');
    }


    public function store()
    {


        $products = products::create($this->validateData()); // insert
        $this->storeImage($products);
        return redirect('/admin/products/create')->with("success","Created Successfully"); // send id of inserted

    }

    public function show(products $products)
    {
        //
    }


    public function edit(products $products)
    {

        return view('admin.products.edit',compact('products'));
    }


    public function update(Request $request, products $products)
    {


        $products->update($this->validateData());
        $this->storeImage($products);
        return redirect('/admin/products/'. $products->id . "/edit")->with('success', 'successfully updated');

    }


    public function destroy(products $products) {


        $products->delete();
        return redirect('/admin/products');
    }




    private function storeImage($products) {


        if(request()->hasFile('img')) {
            $products->update([


            'img'=>request()->img->store('uploads','public')



            ]);
        }

    }



    protected function validateData() {


        $mydata =  [
            'title'=>'required' ,
            'details'=>'required',
            'category_id'=>'required',
        ];

        if(request()->hasFile('img')) {
            $mydata['img'] = 'file|image';
        }

        $validatedData = request()->validate($mydata);



        return $validatedData;


    }

}
