<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\projects;

class ProjectsController extends Controller
{




    public function volunteer_time($project_id) {
        return view('website/projects/time_support');
    }





    public function support($id) {

    return view('website/projects/support_type');

    }

    public function details($id) {

     $project = projects::findorfail($id);

    return view('website/projects/details',compact('project'));

    }

public function list() {
        $projects = projects::all(); 
        return view('website.projects.list' , compact('projects')); 
}

    

    public function index()
    {
        $projects = projects::all();
        return view('admin.projects.list' , compact('projects')); // while query
    }


    public function create()
    {

        return view('admin.projects.create');
    }


    public function store()
    {


        $project = projects::create($this->validateData()); // insert
        $this->storeImage($project);
        return redirect('/admin/projects/create')->with("success","Created Successfully"); // send id of inserted

    }

    public function show($id)
    {
        $project = projects::findorfail($id);
        $testmotional = Testmotinals::all();
        $clients = Clients::all();
        return view('website.projects.details',compact('project','testmotional','clients'));
    }


    public function edit(projects $project)
    {

        return view('admin.projects.edit',compact('project'));
    }


    public function update(Request $request, projects $project)
    {


        $project->update($this->validateData());
        $this->storeImage($project);
        return redirect('/admin/projects/'. $project->id . "/edit")->with('success', 'successfully updated');

    }


    public function destroy(projects $project) {


        $project->delete();
        return redirect('/admin/projects');
    }




    private function storeImage($project) {


        if(request()->hasFile('img')) {
            $project->update([

         //   'header_img' => request()->file('header_img')->store('public/uploads')
                'img'=>request()->img->store('uploads','public')



            ]);
        }

    }



    protected function validateData() {


        $mydata =  [
            'title'=>'required' ,
            'cost'=>'' ,
            'details'=>'required',
        ];

        if(request()->hasFile('img')) {
            $mydata['img'] = 'file|image';
        }

        $validatedData = request()->validate($mydata);



        return $validatedData;


    }

}
