<?php

namespace App\Http\Controllers;

use \App\sliders;
use Illuminate\Http\Request;

class SlidersController extends Controller
{


    public function index()
    {
        $sliders = sliders::all(); // Select
        return view('admin.sliders.list' , compact('sliders')); // while query
    }


    public function create()
    {

        return view('admin.sliders.create');
    }


    public function store()
    {


        $slider = sliders::create($this->validateData()); // insert
        $this->storeImage($slider);
        return redirect('/admin/sliders/create')->with("success","Created Successfully"); // send id of inserted

    }

    public function show(sliders $sliders)
    {
        //
    }


    public function edit(sliders $slider)
    {

        return view('admin.sliders.edit',compact('slider'));
    }


    public function update(Request $request, sliders $slider)
    {


        $slider->update($this->validateData());
        $this->storeImage($slider);
        return redirect('/admin/sliders/'. $slider->id . "/edit")->with('success', 'successfully updated');

    }


    public function destroy(sliders $slider) {


        $slider->delete();
        return redirect('/admin/sliders');
    }




    private function storeImage($slider) {


        if(request()->hasFile('header_img')) {
            $slider->update([


            'header_img'=>request()->header_img->store('uploads','public')



            ]);
        }

    }



    protected function validateData() {


        $mydata =  [
            'title'=>'required' ,
            'details'=>'required',
        ];

        if(request()->hasFile('header_img')) {
            $mydata['header_img'] = 'file|image';
        }

        $validatedData = request()->validate($mydata);



        return $validatedData;


    }

}
