<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use \App\sub_category;
class SubCategoryController extends Controller
{
    
    public function index()
    {
        $sub_category = sub_category::all(); // Select
        return view('admin.sub_category.list' , compact('sub_category')); // while query
    }


    public function create()
    {

        return view('admin.sub_category.create');
    }


    public function store()
    {


        $sub_category = sub_category::create($this->validateData()); // insert
        $this->storeImage($sub_category);
        return redirect('/admin/sub_category/create')->with("success","Created Successfully"); // send id of inserted

    }

    public function show(sub_category $sub_category)
    {
        //
    }


    public function edit(sub_category $sub_category)
    {

        return view('admin.sub_category.edit',compact('sub_category'));
    }


    public function update(Request $request, sub_category $sub_category)
    {


        $sub_category->update($this->validateData());
        $this->storeImage($sub_category);
        return redirect('/admin/sub_category/'. $sub_category->id . "/edit")->with('success', 'successfully updated');

    }


    public function destroy(sub_category $sub_category) {


        $sub_category->delete();
        return redirect('/admin/sub_category');
    }




    private function storeImage($sub_category) {


        if(request()->hasFile('img')) {
            $sub_category->update([


            'img'=>request()->img->store('uploads','public')



            ]);
        }

    }



    protected function validateData() {


        $mydata =  [
            'title'=>'required' ,
            'details'=>'required',
            'main_cat_id'=>'required',
        ];

        if(request()->hasFile('img')) {
            $mydata['img'] = 'file|image';
        }

        $validatedData = request()->validate($mydata);



        return $validatedData;


    }

}
