<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use \App\tameeds;

class TameedsController extends Controller
{
    
 

    public function store()
    {

        $tameed = tameeds::create($this->validateData()); // insert
        return redirect('/tameed')->with("success","Created Successfully"); 

    }

    public function show(tameeds $tameeds)
    {
        //
    }


    public function edit(tameeds $tameed)
    {

        return view('admin.tameeds.edit',compact('tameed'));
    }


    public function update(Request $request, tameeds $tameed)
    {


        $tameed->update($this->validateData());

        return redirect('/admin/tameeds/'. $tameed->id . "/edit")->with('success', 'successfully updated');

    }


    public function destroy(tameeds $tameed) {


        $tameed->delete();
        return redirect('/admin/tameeds');
    }




    protected function validateData() {



        $mydata =  [
            'service_provider_phone'=>'required' ,
            'duration'=>'required',
            'price'=>'required',
            'details'=>'required',
            'user_phone'=>'required',
            'user_id'=>'',
            'fees'=>'',
            'pay_status'=>'',
        ];



        $validatedData = request()->validate($mydata);
    	

        if($validatedData['price'] > 3300) {
        	$validatedData['fees'] = 
        	$validatedData['price'] * ($percentage_from_settings / 100); // 0.035
        }


        if($validatedData['price'] < 3300 && $validatedData['price'] > 1000)
        {
        	$validatedData['fees'] = 100;
        }


        if($validatedData['price'] < 1000) {
        	$validatedData['fees'] = 50;
        }


        return $validatedData;


    }
}
