<?php

namespace App\Http\Controllers;

use \App\testmotinals;
use Illuminate\Http\Request;

class TestmotinalsController extends Controller
{

    public function details($id)
    {
        $partners = testmotinals::findorfail($id);
        return view('website.partners.details' , compact('partners')); // while query
    }

    public function index()
    {
        $testmotinals = testmotinals::all(); // Select
        return view('admin.testmotinals.list' , compact('testmotinals')); // while query
    }


    public function create()
    {

        return view('admin.testmotinals.create');
    }


    public function store()
    {


        $testmotinal = testmotinals::create($this->validateData()); // insert
        $this->storeImage($testmotinal);
        return redirect('/admin/testmotinals/create')->with("success","Created Successfully"); // send id of inserted

    }

    public function show(testmotinals $testmotinals)
    {
        //
    }


    public function edit(testmotinals $testmotinal)
    {

        return view('admin.testmotinals.edit',compact('testmotinal'));
    }


    public function update(Request $request, testmotinals $testmotinal)
    {


        $testmotinal->update($this->validateData());
        $this->storeImage($testmotinal);
        return redirect('/admin/testmotinals/'. $testmotinal->id . "/edit")->with('success', 'successfully updated');

    }


    public function destroy(testmotinals $testmotinal) {


        $testmotinal->delete();
        return redirect('/admin/testmotinals');
    }




    private function storeImage($testmotinal) {


        if(request()->hasFile('header_img')) {
            $testmotinal->update([

                'header_img'=>request()->header_img->store('uploads','public')


            ]);
        }

    }



    protected function validateData() {


        $mydata =  [
            'title'=>'required' ,
            'details'=>'' ,
        ];

        if(request()->hasFile('header_img')) {
            $mydata['header_img'] = 'file|image';
        }

        $validatedData = request()->validate($mydata);



        return $validatedData;


    }

}
