<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Auth;
use \App\volunteer_project;

class VolunteerProjectController extends Controller
{


  public function destroy($id) {

        $volunteer_project = volunteer_project::findorfail($id);
        $volunteer_project->delete();
        return redirect('/admin/volunteer_projects');

    }

    public function details($id) {

    $volunteer_project = volunteer_project::findorfail($id);
    return view('/admin/volunteer_projects/details',compact('volunteer_project'));

    }

    public function list() {
        $volunteer_project = volunteer_project::all(); 
        return view('/admin/volunteer_projects/list' , compact('volunteer_project')); 
    }




        public function eat_support($project_id) {

		$mydata =  [
            'details'=>'', 
        ];
        
        $validatedData = request()->validate($mydata);
        $validatedData['project_id'] = $project_id;
        $validatedData['volunteer_type'] = "eat";
        $validatedData['volunteer_id'] = Auth::guard('volunteer')->user()->id;
        $page = volunteer_project::create($validatedData); 


		return redirect('/volunteer')->with("message","Created Successfully");
		}









        public function money_support($project_id) {

		$mydata =  [
            'volunteer_value'=>'required', 
        ];
        $validatedData = request()->validate($mydata);
        $validatedData['project_id'] = $project_id;
        $validatedData['volunteer_type'] = "money";
        $validatedData['details'] = "money";
        $validatedData['volunteer_id'] = Auth::guard('volunteer')->user()->id;
        $page = volunteer_project::create($validatedData); 


		return redirect('/volunteer')->with("message","Created Successfully");
}

    

        public function time_support($project_id) {

		$mydata =  [
            'details'=>'', 
        ];
        $validatedData = request()->validate($mydata);
        $validatedData['project_id'] = $project_id;
        $validatedData['volunteer_type'] = "time";
        $validatedData['volunteer_id'] = Auth::guard('volunteer')->user()->id;
        $page = volunteer_project::create($validatedData); 


		return redirect('/volunteer')->with("message","Created Successfully");
}


}
