@extends('admin.template')

@section('content')



    <div class="card">
        <div class="card-header">
            <h3 class="card-title">List of Volunteers</h3>
        </div>
        <!-- /.card-header -->
        <div class="card-body">
            <table id="example1" class="table table-bordered table-striped" style="">
                <thead>
                <tr>
                    <th>#</th>
                    <th>Date</th>
                    <th>Volunteer</th>
                    <th>Project</th>
                    <th>Volunteer Type</th>
                    <th>Volunteer Value</th>
                    <th>Action</th>
                </tr>
                </thead>
                <tbody>

@forelse($volunteer_project as $volunteer_project)

                <tr>
                    <td> {{ $volunteer_project->id }}</td>
                    <td> {{ $volunteer_project->created_at }} </td>
                    <td> {{ $volunteer_project->volunteer->name }} </td>
                    <td> {{ $volunteer_project->project->title }} </td>
                    <td> {{ strtoupper($volunteer_project->volunteer_type) }} </td>
                    <td> {{ $volunteer_project->volunteer_value }} </td>

                    <td>

                          <a class="btn btn-info btn-sm" href="/admin/volunteer_projects/{{$volunteer_project->id}}">
                            <i class="fas fa-eye-alt"></i>
                            View
                            </a>


                            <span class="btn btn-danger btn-sm" >
                                <form action="/admin/volunteer_projects/{{ $volunteer_project->id }}" method="post">
                                    @method('DELETE')
                                    <button onclick="return confirm('Are you sure you want to delete this ?');" style="border: 0px; background:none; color: white">
                                        <i class="fas fa-trash"></i>
                                        Delete</button>
                                    @csrf
                                </form>


                            </span>

                    </td>
                </tr>

    @empty

    <tr>
       <div style="color: red; font-size: 18px; font-weight: bolder;">No Data Available</div>
    </tr>

                @endforelse







                </tbody>

            </table>
        </div>
        <!-- /.card-body -->
    </div>




@endsection
