<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
Route::get('/foo', function(){
    Artisan::call('storage:link', []);
    return 'success';
});


Route::view('tameed','website/tameeds/order');
Route::post('tameed','TameedsController@store');


Route::group(['middleware'=>'language'],function ()
{    
    Route::get('/test', function(){
          return __('1.home');

    });

Route::get('/test', function(){
    echo 'success'."_".session('lang');

    $row = [];
    $row['title_en'] = "hi";
    $row['title_ar'] = "مرحبا";

    echo "<br><br><br>";
    $la = '_'.session('lang');

    echo $row['title'.$la];
});




});





Route::get('lang/{locale}',function($lang){
       \Session::put('locale',$lang);
       return redirect()->back();   
});


    Route::post('/services/order','OrderController@store');

  
    Route::view('/','website.home.index');
    Route::view('/contact','website.contact.contact');
    Route::post('/contact','ContactController@store');


    Route::get('/pages/{id}','PagesController@details');

    Route::view('/services','website.services.services');
    Route::view('/services/order','website.services.order');
    Route::view('/services/deliver','website.services.deliver');
    Route::view('/services/provide','website.services.provide');


    Route::view('/partners','website.partners.partners');
    Route::get('/partners/{id}','TestmotinalsController@details');

   
    Route::view('/news','website.news.news');
    Route::get('/news/{id}','NewsController@details');


    Route::get('/projects','ProjectsController@list');
    Route::get('/project/{id}','ProjectsController@details');
    Route::get('/support/{id}','ProjectsController@support')->middleware('volunteer.auth');
   

    // Time Volunteer
    Route::get('/support/{project_id}/time','ProjectsController@volunteer_time')->middleware('volunteer.auth');

    Route::post('/support/{project_id}/time','VolunteerProjectController@time_support')->middleware('volunteer.auth');
    // End Time Volunteer


    // Money Volunteer
    Route::view('/support/{project_id}/money','website.projects.money_support')->middleware('volunteer.auth');

    Route::post('/support/{project_id}/money','VolunteerProjectController@money_support')->middleware('volunteer.auth');
    // End Money Volunteer 



    // Eat Volunteer
    Route::view('/support/{project_id}/eat','website.projects.eat_support')->middleware('volunteer.auth');

    Route::post('/support/{project_id}/eat','VolunteerProjectController@eat_support')->middleware('volunteer.auth');
    // End Eat Volunteer
































    Route::redirect('/admin/home','/admin/index');

// Admin Links
Route::group(['middleware' => ['auth:admin']], function() {


    Route::view('/admin/index', 'admin.index')->name('dashboard');

    // ========================= Pages ===================================================
    Route::get('/admin/page/create','PagesController@create');
    Route::post('/admin/pages','PagesController@store');
//-------
    Route::get('/admin/pages','PagesController@index');
    Route::get('/admin/pages/{page}/edit','PagesController@edit');
    Route::put('/admin/pages/{page}','PagesController@update');
//-------
    Route::delete('/admin/pages/{page}','PagesController@destroy');



    // ========================= Partners  ===================================================
    Route::get('/admin/partners/create','PartnersController@create');
    Route::post('/admin/partners','PartnersController@store');
//-------
    Route::get('/admin/partners','PartnersController@index');
    Route::get('/admin/partners/{partner}/edit','PartnersController@edit');
    Route::put('/admin/partners/{partner}','PartnersController@update');
//-------
    Route::delete('/admin/partners/{partner}','PartnersController@destroy');


    // ========================= Products  ===================================================
    Route::get('/admin/products/create','ProductsController@create');
    Route::post('/admin/products','ProductsController@store');
//-------
    Route::get('/admin/products','ProductsController@index');
    Route::get('/admin/products/{products}/edit','ProductsController@edit');
    Route::put('/admin/products/{products}','ProductsController@update');
//-------
    Route::delete('/admin/products/{products}','ProductsController@destroy');



    // ========================= Categories ===================================================
    Route::get('/admin/categories/create','CategoriesController@create');
    Route::post('/admin/categories','CategoriesController@store');
//-------
    Route::get('/admin/categories','CategoriesController@index');
    Route::get('/admin/categories/{categories}/edit','CategoriesController@edit');
    Route::put('/admin/categories/{categories}','CategoriesController@update');
//-------
    Route::delete('/admin/categories/{categories}','CategoriesController@destroy');



















    // ========================= Main Category  ========================================
    Route::get('/admin/main_category/create','MainCategoryController@create');
    Route::post('/admin/main_category','MainCategoryController@store');
//-------
    Route::get('/admin/main_category','MainCategoryController@index');
    Route::get('/admin/main_category/{main_category}/edit','MainCategoryController@edit');
    Route::put('/admin/main_category/{main_category}','MainCategoryController@update');
//-------
    Route::delete('/admin/main_category/{main_category}','MainCategoryController@destroy');


    // ========================= Sub Category  ========================================
    Route::get('/admin/sub_category/create','SubCategoryController@create');
    Route::post('/admin/sub_category','SubCategoryController@store');
//-------
    Route::get('/admin/sub_category','SubCategoryController@index');
    Route::get('/admin/sub_category/{sub_category}/edit','SubCategoryController@edit');
    Route::put('/admin/sub_category/{sub_category}','SubCategoryController@update');
//-------
    Route::delete('/admin/sub_category/{sub_category}','SubCategoryController@destroy');




    // ========================= News ===================================================
    Route::get('/admin/news/create','NewsController@create');
    Route::post('/admin/news','NewsController@store');
//-------
    Route::get('/admin/news','NewsController@index');
    Route::get('/admin/news/{new}/edit','NewsController@edit');
    Route::put('/admin/news/{new}','NewsController@update');
//-------
    Route::delete('/admin/news/{new}','NewsController@destroy');





    // ========================= Projects ===================================================
    Route::get('/admin/projects/create','ProjectsController@create');
    Route::post('/admin/projects','ProjectsController@store');
//-------
    Route::get('/admin/projects','ProjectsController@index');
    Route::get('/admin/projects/{project}/edit','ProjectsController@edit');
    Route::put('/admin/projects/{project}','ProjectsController@update');
//-------
    Route::delete('/admin/projects/{project}','ProjectsController@destroy');





//***************************** Volunteer On Projects


Route::get('/admin/volunteer_projects','VolunteerProjectController@list');
Route::get('/admin/volunteer_projects/{project_id}','VolunteerProjectController@details');
Route::delete('/admin/volunteer_projects/{project_id}','VolunteerProjectController@destroy');






// ========================= Testmotionals ===================================================
    Route::get('/admin/testmotinals/create','TestmotinalsController@create');
    Route::post('/admin/testmotinals','TestmotinalsController@store');
//-------
    Route::get('/admin/testmotinals','TestmotinalsController@index');
    Route::get('/admin/testmotinals/{testmotinal}/edit','TestmotinalsController@edit');
    Route::put('/admin/testmotinals/{testmotinal}','TestmotinalsController@update');
//-------
    Route::delete('/admin/testmotinals/{testmotinal}','TestmotinalsController@destroy');




// ========================= Sliders ===================================================
    Route::get('/admin/sliders/create','SlidersController@create');
    Route::post('/admin/sliders','SlidersController@store');
//-------
    Route::get('/admin/sliders','SlidersController@index');
    Route::get('/admin/sliders/{slider}/edit','SlidersController@edit');
    Route::put('/admin/sliders/{slider}','SlidersController@update');
//-------
    Route::delete('/admin/sliders/{slider}','SlidersController@destroy');



    Route::get('/admin/categories/create','CategoriesController@create');
    Route::post('/admin/categories','CategoriesController@store');
//-------
    Route::get('/admin/categories','CategoriesController@index');
    Route::get('/admin/categories/{categories}/edit','CategoriesController@edit');
    Route::put('/admin/categories/{categories}','CategoriesController@update');
//-------
    Route::delete('/admin/categories/{categories}','CategoriesController@destroy');



    Route::get('/admin/catalogs/create','CatalogController@create');
    Route::post('/admin/catalogs','CatalogController@store');
//-------
    Route::get('/admin/catalogs','CatalogController@index');
    Route::get('/admin/catalogs/{catalog}/edit','CatalogController@edit');
    Route::put('/admin/catalogs/{catalog}','CatalogController@update');
//-------
    Route::delete('/admin/catalogs/{catalog}','CatalogController@destroy');




   
    // Contact Admin
    Route::get('/admin/contact','contactAdminController@list');
    Route::delete('/admin/contact/{id}','contactAdminController@destroy');


  // Order Admin
    Route::get('/admin/orders','OrderController@list');
    Route::delete('/admin/orders/{id}','OrderController@destroy');





});



